IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Rec_Generar_Item') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Cbtes_Rec_Generar_Item
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Rec_Generar_Item] @pJson VARCHAR(8000)
AS
SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans				TINYINT
DECLARE @pModoDebug					TINYINT
DECLARE @pId_Trans					INT
DECLARE @pItem						SMALLINT
DECLARE @pId_Producto				VARCHAR(14)
DECLARE @pCantidad					DECIMAL(15,5)
DECLARE @pId_Trans_A_Cancelar		INT
DECLARE @pImporte_A_Cancelar		DECIMAL(16,2)
DECLARE @pOmitir_Resultado_OK       TINYINT

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Trans					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')),0)
SET @pItem						= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Item')),0)
SET @pId_Producto				= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')),'')
SET @pCantidad					= ISNULL(CONVERT(DECIMAL(15,5), dbo.CF_JSON_VALUE(@pJson,'Cantidad')),0)
SET @pId_Trans_A_Cancelar		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans_A_Cancelar')),0)
SET @pImporte_A_Cancelar		= ISNULL(CONVERT(DECIMAL(16,2), dbo.CF_JSON_VALUE(@pJson,'Importe_A_Cancelar')),0)
SET @pOmitir_Resultado_OK		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Omitir_Resultado_OK')),0)
/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/
	
/*Declaracion Variables Locales*/
DECLARE @Id_Estado_Cbte			SMALLINT
DECLARE @Calle					CHAR(3)
DECLARE @Columna				CHAR(3)
DECLARE @Fila					CHAR(3)
DECLARE @Bultos					DECIMAL(15,5)
DECLARE @Despacho				VARCHAR(100)
DECLARE @Serie					VARCHAR(100)
DECLARE @Fecha_Venc				DATETIME
DECLARE @Observacion			VARCHAR(8000)
DECLARE @Millas					INT
DECLARE @Cantidad_Saldo			DECIMAL(15,5)
DECLARE @Precio_Grav			DECIMAL(15,5)
DECLARE @Precio_Exen			DECIMAL(15,5)
DECLARE @Imp_Gravado			DECIMAL(12,2)
DECLARE @Imp_Exento				DECIMAL(12,2)
DECLARE @Analisis				VARCHAR(30)
DECLARE @Lote					VARCHAR(20)
DECLARE @Flag_QA				CHAR(1)
DECLARE @Fecha_QA				DATETIME
DECLARE @Porc_Iva				DECIMAL(5,2)
DECLARE @Bonif					DECIMAL(5,2)
DECLARE @Descripcion_producto	VARCHAR(100)
DECLARE @Id_Unidad_Medida		CHAR(4)
DECLARE @Imp_Final				DECIMAL(15,5)
DECLARE @Costo					DECIMAL(15,5)
DECLARE @Imp_Iva				DECIMAL(12,2)
DECLARE @Precio					DECIMAL(15,5)
DECLARE @Id_Costo				INT
DECLARE @Id_Cliente				INT
DECLARE @Id_Tarea				SMALLINT
DECLARE @Fecha_Caducidad		DATETIME
DECLARE @Id_Pais				CHAR(3)
DECLARE @Id_Usuario				SMALLINT
DECLARE @CANTIDAD_EQUIV			DECIMAL(15,5)
DECLARE @Costo_MO				DECIMAL(15,5)
DECLARE @Costo_GF				DECIMAL(15,5)
DECLARE @Id_Cond_Pago			SMALLINT
DECLARE @Fecha_Proceso			DATETIME
DECLARE @Id_Balanza				CHAR(10)
DECLARE @Orden					SMALLINT
DECLARE @Flag_NoImp_Factura		TINYINT
DECLARE @Nro_Tag				VARCHAR(30)
DECLARE @Fecha_Elaboracion		DATETIME
DECLARE @Costo_Comparativo		DECIMAL(13,4)
DECLARE @Id_Cta_Banco			SMALLINT
DECLARE @Porc_Imp_INT			DECIMAL(5,2)

DECLARE @Nro_Cuota				SMALLINT
DECLARE @Id_Empresa				SMALLINT
DECLARE @Id_Cliente_Cab			INT
DECLARE @Fecha_Vence			DATETIME
DECLARE @Descripcion			VARCHAR(100)
DECLARE @Importe				DECIMAL(12,2)
DECLARE @Nro_Cuota_Origen		SMALLINT
DECLARE @Id_Moneda				CHAR(3)
DECLARE @Saldo					DECIMAL(12,2)
DECLARE @Nro_FacCre				INT

DECLARE @Flag_Existe_Producto	TINYINT
DECLARE @Id_Tipo_Cbte			CHAR(4)
DECLARE @Fecha					DATETIME
DECLARE @Item					SMALLINT
DECLARE @Item_D					SMALLINT
DECLARE @Cantidad				DECIMAL(14, 2)
DECLARE @Fecha_Aplic			DATETIME

DECLARE @Id_Estado_Cbte_Id_Trans_Origen	SMALLINT
DECLARE @Id_Trans_Origen		INT
DECLARE @Id_Trans_CA			INT
DECLARE @Saldo_Cbte				DECIMAL(16,2)

DECLARE @Mensaje				VARCHAR(100)
/*Fin de Declaraciones Variables Locales */


BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Rec_Generar_Item'
		PRINT 'Parametros:'
		PRINT  'Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans) + ' Id_Producto: ' + @pId_Producto + ' Cantidad: ' + CONVERT(VARCHAR(20), @pCantidad) + ' Id_Trans_A_Cancelar: ' + CONVERT(VARCHAR(10), @pId_Trans_A_Cancelar) + ' Importe_A_Cancelar: ' + CONVERT(VARCHAR(20), @pImporte_A_Cancelar)
	END

	/*Validaciones******************************************************************/
	
	IF(@pId_Trans		 = 0) RAISERROR ('Id_Trans can not be zero.', 16,  1 ) 

	/*Fin Validaciones **************************************************************/
	
	/*Seteo Respuesta del Stored *********************************************/

	IF @pOmitir_Resultado_OK = 0
	BEGIN
		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT')  + ',' +
									dbo.CF_Json_ParsearVariable('item', @Item, 'SMALLINT')  + ',' +
									dbo.CF_Json_ParsearVariable('id_producto', @pId_Producto, 'VARCHAR')  + ',' +
									dbo.CF_Json_ParsearVariable('Importe_A_Cancelar', @pImporte_A_Cancelar, 'DECIMAL') +
									'}'

		SELECT	 0						AS ErrorNumber 
				,0						AS ErrorSeverity  
				,0						AS ErrorState 
				,0						AS ErrorProcedure  
				,0						AS ErrorLine		
				,@rtaMsjStored			AS ErrorMessage
	END

	/*Asignación de Variables *********************************************************/
	
	SELECT  @Id_Tipo_Cbte	= ISNULL(Id_Tipo_Cbte, ''),
			@Fecha			= ISNULL(Fecha, '19000101'),
			@Id_Cliente_Cab = ISNULL(Id_Cliente, 0),
			@Id_Moneda		= Id_Moneda
	FROM Cbtes
	WHERE 
	Id_Trans = @pId_Trans

	/*************************************************************************************************/

	SELECT  @Id_Estado_Cbte	= ISNULL(Id_Estado_Cbte_Item, 0) FROM Cbtes_Tipos  WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte

	/*************************************************************************************************/

	IF(@pId_Producto <> '')
	BEGIN
		SELECT  @Calle	= ISNULL(Calle, ''),
			@Columna	= ISNULL(Columna, ''),
			@Fila		= ISNULL(Fila, ''),
			@Despacho	= ISNULL(Despacho, '')
		FROM Productos
		WHERE 
		Id_Producto = @pId_Producto
	END
	ELSE
	BEGIN
		SET @Calle		=  ''
		SET @Columna	= ''
		SET @Fila		=  ''
		SET @Despacho	=  ''
	END

	/*************************************************************************************************/

	IF(@pId_Trans_A_Cancelar <> 0)
	BEGIN
		SELECT @Id_Estado_Cbte_Id_Trans_Origen = ISNULL(Id_Estado_Cbte, 0), @Saldo_Cbte = Saldo FROM Cbtes 	WHERE Id_Trans = @pId_Trans_A_Cancelar
	END
	ELSE
	BEGIN
		SET @Id_Estado_Cbte_Id_Trans_Origen = 0 
		SET @Saldo_Cbte = 0 
	END

	/*************************************************************************************************/

	IF(@pId_Trans_A_Cancelar <> 0)
	BEGIN
		SET @Observacion			= (dbo.CF_Cbte_Descrip(@pId_Trans_A_Cancelar))
		SET @Descripcion_producto	= (dbo.CF_Cbte_Descrip(@pId_Trans_A_Cancelar))
	END
	ELSE
	BEGIN
		SET @Observacion			= ''
		SET @Descripcion_producto	= ''
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Observacion: ' + @Observacion + '. @Descripcion_producto' + @Descripcion_producto
	END

	/*************************************************************************************************/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Id_Estado_Cbte_Id_Trans_Origen: ' + CONVERT(VARCHAR(10), @Id_Estado_Cbte_Id_Trans_Origen)
	END

	IF(@Id_Estado_Cbte_Id_Trans_Origen IN (1,4) /*Pendiente*/)
	BEGIN
		SET @Fecha_Venc		= @Fecha		
		SET @Imp_Gravado	= @pImporte_A_Cancelar
		SET @Item 			= @pItem 
		SET @Imp_Final		= @Imp_Gravado
		/*TO-DO: De aca para abajo por ahora por Default*/
		SET @Bultos			= 0
		SET @Serie			= ''
		SET @Millas			= 0
		SET @Cantidad_Saldo = 0
		SET @Precio_Grav	= 0
		SET @Precio_Exen	= 0	
		SET @Imp_Exento		= 0
		SET @Analisis		= ''
		SET @Lote			= ''
		SET @Flag_QA		= ''
		--SET @Fecha_QA = NULL
		SET @Porc_Iva		= 0
		SET @Bonif			= 0
		SET @Id_Unidad_Medida = ''
		--SET @Imp_Final = 0
		SET @Costo			= 0
		SET @Imp_Iva		= 0
		SET @Precio			= 0
		SET @Id_Costo		= 0
		SET @Id_Cliente		= 0
		SET @Id_Tarea		= 0
		--SET @Fecha_Caducidad = NULL
		SET @Id_Pais		= ''
		SET @Id_Usuario		= 0
		SET @Cantidad_Equiv = 0
		SET @Costo_MO		= 0
		SET @Costo_GF		= 0
		SET @Id_Cond_Pago	= 0
		--SET @Fecha_Proceso NULL
		SET @Id_Balanza		= ''
		SET @Orden			= 0
		SET @Flag_NoImp_Factura = 0
		SET @Nro_Tag		= ''
		--SET @Fecha_Elaboracion = NULL
		SET @Costo_Comparativo = 0
		SET @Id_Cta_Banco	= 0
		SET @Porc_Imp_Int	= 0
		
		IF(@pId_Trans_A_Cancelar <> 0)
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Inserta Cbtes_Items'
			END

			INSERT INTO dbo.Cbtes_Items
			(Id_Trans,		Item,				Id_Producto,
			Id_Estado_Cbte,	Cantidad,			Calle,
			Columna,		Fila,				Bultos,
			Despacho,		Serie,				Fecha_Venc,
			Observacion,	Millas,				Cantidad_Saldo,
			Precio_Grav,	Precio_Exen,		Imp_Gravado,
			Imp_Exento,		Analisis,			Lote,
			Flag_QA,		Fecha_QA,			Porc_Iva,
			Bonif,			Descripcion_producto,Id_Unidad_Medida,
			Imp_Final,		Costo,				Imp_Iva,
			Precio,			Id_Costo,			Id_Cliente,
			Id_Tarea,		Fecha_Caducidad,	Id_Pais,
			Id_Usuario,		Cantidad_Equiv,		Costo_MO,
			Costo_GF,		Id_Cond_Pago,		Fecha_Proceso,
			Id_Balanza,		Orden,				Flag_NoImp_Factura,
			Nro_Tag,		Fecha_Elaboracion,	Costo_Comparativo,
			Id_Cta_Banco,	Porc_Imp_Int)
			VALUES
			(@pId_Trans,	@pItem,				@pId_Producto,
			@Id_Estado_Cbte,@pCantidad,			@Calle,
			@Columna,		@Fila,				@Bultos,
			@Despacho,		@Serie,				@Fecha_Venc,
			@Observacion,	@Millas,			@Cantidad_Saldo,
			@Precio_Grav,	@Precio_Exen,		@Imp_Gravado,
			@Imp_Exento,	@Analisis,			@Lote,
			@Flag_QA,		@Fecha_QA,			@Porc_Iva,
			@Bonif,			@Descripcion_producto,@Id_Unidad_Medida,
			@Imp_Final,		@Costo,				@Imp_Iva,
			@Precio,		@Id_Costo,			@Id_Cliente,
			@Id_Tarea,		@Fecha_Caducidad,	@Id_Pais,
			@Id_Usuario,	@Cantidad_Equiv,	@Costo_MO,
			@Costo_GF,		@Id_Cond_Pago,		@Fecha_Proceso,
			@Id_Balanza,	@Orden,				@Flag_NoImp_Factura,
			@Nro_Tag,		@Fecha_Elaboracion,	@Costo_Comparativo,
			@Id_Cta_Banco,	@Porc_Imp_Int)
		END
	END	

	/*****************************************************************************/

	IF(@pId_Trans_A_Cancelar <> 0)
	BEGIN
		SET @Descripcion		= dbo.CF_Cbte_Descrip(@pId_Trans)
	END
	ELSE
	BEGIN
		SET @Descripcion		= ''
	END

	SET @Nro_Cuota			= @pItem
	SET @Fecha_Vence		= @Fecha	
	SET @Importe			= (@pImporte_A_Cancelar * (-1))
	SET @Id_Estado_Cbte		= 0 --En Carga
	SET @Observacion		= ''
	SET @Saldo				= @Importe
	SET @Nro_FacCre			= 0
	
	IF(@Id_Estado_Cbte_Id_Trans_Origen IN (1,4)/*Pendiente*/)
	BEGIN
		SET @Id_Trans_Origen = @pId_Trans_A_Cancelar
		SET @Nro_Cuota_Origen = 1
	END
	ELSE
	BEGIN
		SET @Id_Trans_Origen = 0
		SET @Nro_Cuota_Origen = 0
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Inserta Clientes_CtaCte'
	END

	INSERT INTO dbo.Clientes_CtaCte
	(Id_Trans,			Nro_Cuota,				Id_Empresa,
	Id_Cliente,			Fecha,					Fecha_Vence,
	Descripcion,		Importe,				Id_Estado_Cbte,
	Observacion,		Id_Trans_Origen,		Nro_Cuota_Origen,
	Id_Moneda,			Saldo,					Nro_FacCre)
	VALUES
	(@pId_Trans,		@Nro_Cuota,				@Id_Empresa,
	@Id_Cliente_Cab,	@Fecha,					@Fecha_Vence,
	@Descripcion,		@Importe,				@Id_Estado_Cbte,
	@Observacion,		@Id_Trans_Origen,		@Nro_Cuota_Origen,
	@Id_Moneda,			@Saldo,					@Nro_FacCre)

	/*****************************************************************************/
	
	SET @Item_D	= 1
	SET @Cantidad = 0
	
	IF(@Id_Estado_Cbte_Id_Trans_Origen IN (1,4) /*Pendiente*/)
	BEGIN
		SET @Id_Trans_CA	= @pId_Trans_A_Cancelar
		SET @Item			= 1
	END
	ELSE
	BEGIN
		SET @Id_Trans_CA	= 0
		SET @Item			= 0
	END

	IF NOT EXISTS (	SELECT 1 
					FROM Cbtes_Aplica 
					WHERE 
					Id_Trans = @Id_Trans_CA
					AND	Item = @Item
					AND	Id_Trans_D = @pId_Trans
					AND	Item_D = @Item_D)
    BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Inserta Cbtes_Aplica'
		END

		INSERT INTO dbo.Cbtes_Aplica
		(Id_Trans,			Item,				Id_Trans_D,
		Item_D,				Cantidad,			Importe,
		Fecha_Aplic)
		VALUES
		(@Id_Trans_CA,		@Item,				@pId_Trans,
		@Item_D,			@Cantidad,			@pImporte_A_Cancelar,
		@Fecha_Aplic)
    END
	ELSE
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Actualiza Cbtes_Aplica'
		END

		UPDATE Cbtes_Aplica
		SET 
		Importe = Importe + @pImporte_A_Cancelar
		WHERE 
		Id_Trans = @Id_Trans_CA
		AND	Item = @Item
		AND	Id_Trans_D = @pId_Trans
		AND	Item_D = @Item_D
	END
	/*****************************************************************************/
	
	IF ((@pId_Trans_A_Cancelar <> 0) AND (@Id_Estado_Cbte_Id_Trans_Origen IN (1,4)/*Pendiente*/))
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Actualiza Id_Trans_A_Cancelar: ' +  CONVERT(VARCHAR(10), @pId_Trans_A_Cancelar)
		END

	    IF @Saldo_Cbte - ABS(@pImporte_A_Cancelar) <= 0
		BEGIN
			UPDATE Cbtes SET Id_Estado_Cbte = 2, Saldo = 0 WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Cbtes_Items SET Id_Estado_Cbte = 2 WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 2, Saldo = 0 WHERE Id_Trans = @pId_Trans_A_Cancelar
        END
		ELSE
		BEGIN
			UPDATE Cbtes SET Id_Estado_Cbte = 4, Saldo = Saldo - ABS(@pImporte_A_Cancelar) WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Cbtes_Items SET Id_Estado_Cbte = 4 WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 4, Saldo = Saldo - @pImporte_A_Cancelar WHERE Id_Trans = @pId_Trans_A_Cancelar

		END
	END

	/*****************************************************************************/

	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END

	/*===================================================================*/	
	IF @pOmitir_Resultado_OK = 0
	BEGIN
		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT')  + ',' +
									dbo.CF_Json_ParsearVariable('item', @Item, 'SMALLINT')  + ',' +
									dbo.CF_Json_ParsearVariable('id_producto', @pId_Producto, 'VARCHAR')  + ',' +
									dbo.CF_Json_ParsearVariable('id_estado_cbte', @Id_estado_Cbte, 'INT')  + ','  +
									dbo.CF_Json_ParsearVariable('Importe', @Imp_Final, 'DECIMAL') + ',' +
									dbo.CF_Json_ParsearVariable('Importe_A_Cancelar', @pImporte_A_Cancelar, 'DECIMAL') +
									'}'

		SELECT		0						AS ErrorNumber 
					,0						AS ErrorSeverity  
					,0						AS ErrorState 
					,0						AS ErrorProcedure  
					,0						AS ErrorLine		
					,@rtaMsjStored			AS ErrorMessage
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Rec_Generar_Item'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	
	RETURN 9999
END CATCH

RETURN 0 